
<?php $__env->startSection('content'); ?>
<style>
  button.dt-button, div.dt-button, a.dt-button, input.dt-button {
    border-radius: 5px;
    color: white;
    background-color: rgb(197, 7, 178);
    box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;
}

button.dt-button:hover:not(.disabled), div.dt-button:hover:not(.disabled), a.dt-button:hover:not(.disabled), input.dt-button:hover:not(.disabled) {
    border: 1px solid #666;
    background-color: rgb(29, 29, 29);
}

.text-danger {
    color: red;
    font-weight: 900;
}

</style>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
         
          <div class="row grid-margin">
            <div class="col-12">
              <div class="card card-statistics">
                <div class="card-body">
                  <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
                    <div class="statistics-item">
                      <p>
                          <i class="icon-sm fa fa-user mr-2"></i>
                          Total Top-Up Amount
                      </p>
                      <h4><?php echo e(number_format($pettyCash, 2)); ?></h4>
                  </div>
                  <div class="statistics-item">
                      <p>
                          <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                          Total Expenses
                      </p>
                      <h4><?php echo e(number_format($Expenses, 2)); ?></h4>
                  </div>
                  <div class="statistics-item">
                      <p>
                          <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                          Balance
                      </p>
                      <h4><?php echo e(number_format($pettyCash - $Expenses, 2)); ?></h4>
                      <?php
                          $percentageChange = $Expenses > 0 ? (($pettyCash - $Expenses) / $Expenses) * 100 : 0;
                      ?>
                      <?php if($percentageChange > 0): ?>
                          <label class="badge badge-outline-success badge-pill">Balance Amount</label>
                      <?php else: ?>
                          <label class="badge badge-outline-danger badge-pill">Outstanding Amount</label>
                      <?php endif; ?>
                  </div>
                      
                  </div>
                </div>
              </div>
            </div>
          </div>
         
          <div class="content-wrapper">
            
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">Data table</h4>
                <div class="row">
                  <div class="col-12">
                    <div class="table-responsive" style="overflow-x: auto; -webkit-overflow-x: auto;">
                        <table id="example" class="table table-striped table-hover table-product  nowrap" style="width: 100%; ">
                        <thead>
                          <tr>
                              <th>Date</th>
                              <th>Sale Amount</th>
                              <th>Purchase Payment</th>
                              <th>Expenses</th>
                              <th>Balance</th>
                              <th>View</th>
                          </tr>
                        </thead>
                        <tbody>
                         
                      
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <div class="card">
                <div class="card-body">
                  <div class="d-md-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-facebook btn-rounded">
                        <i class="fab fa-facebook-f"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Facebook</h5>
                        <p class="mb-0">813 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-twitter btn-rounded">
                        <i class="fab fa-twitter"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Twitter</h5>
                        <p class="mb-0">9000 followers</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-google btn-rounded">
                        <i class="fab fa-google-plus-g"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Google plus</h5>
                        <p class="mb-0">780 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center">
                      <button class="btn btn-social-icon btn-linkedin btn-rounded">
                        <i class="fab fa-linkedin-in"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Linkedin</h5>
                        <p class="mb-0">1090 connections</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:../../partials/_footer.html -->
        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © 2025  <a href="https://www.urbanui.com/" target="_blank">Urbanui</a>. All rights reserved.</span>
            <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Hand-crafted & made with <i class="far fa-heart text-danger"></i></span>
          </div>
        </footer>
        <!-- partial -->
      </div>
     
     
      <script>
$( document ).ready(function() {
  var branch_id = <?php echo e(Session::get('branch_id')); ?> 
  // alert("hi")
  $(document).ready(function() {
    $('#example').DataTable({
        dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],
        processing: true,
        info: true,
        responsive: true,
        lengthMenu: [
            [10, 25, 50, 100, 200, -1],
            [10, 25, 50, 100, 200, "All"]
        ],
        ajax: {
            url: "<?php echo e(route('get_daily_report_list')); ?>",
            dataType: 'json',
            dataSrc: '', // Use an empty string if your data array is directly returned
        },
        columns: [
            { data: 'date', name: 'date' },
            {
                data: 'total_Sale_amount',
                name: 'total_Sale_amount',
                render: function(data, type, row) {
                    return parseFloat(data).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                }
            },
            {
                data: 'purchase_amount',
                name: 'purchase_amount',
                render: function(data, type, row) {
                    return parseFloat(data).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                }
            },

            
            {
                data: 'total_expenses',
                name: 'total_expenses',
                render: function(data, type, row) {
                    return parseFloat(data).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                }
            },
            // {
            //     data: 'balance',
            //     name: 'balance',
            //     render: function(data, type, row) {
            //         return parseFloat(data).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
            //     }
            // },

            
          {
    data: null,
    render: function(data, type, row) {
        let saleAmount = parseFloat(row.total_Sale_amount) || 0;
        let purchaseAmount = parseFloat(row.purchase_amount) || 0;
        let expenses = parseFloat(row.total_expenses) || 0;

        let balance = saleAmount - (purchaseAmount + expenses);

        var textColorClass = balance < 0 ? 'text-danger' : '';
        var formattedResult = balance.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });

        return '<span class="' + textColorClass + '">' + formattedResult + '</span>';
    }
},

            {
                data: 'date',
                name: 'date',
                render: function(data, type, row, meta) {
                    return `<button type="button" class="btn btn-outline-success view" data-id="${data}" style="height:32px; margin:0px;">View</button>`;
                }
            }
        ],
        createdRow: function(row, data, dataIndex) {
            $(row).css('font-size', '15px'); // Example row styling
        }
    });
});
$(document).on('click', '.view', function() {
            var date = $(this).data('id');
         

            var url = '/daily-report-data?date=' + date;
            window.location.href = url;
        });

      
});
      
      </script>
<?php $__env->stopSection(); ?>
      <!-- main-panel ends -->
    
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\USER\Desktop\laravel Chat\Sunsmart pety cash\susmart\resources\views/Section/Reports/DailyReport.blade.php ENDPATH**/ ?>