<?php $__env->startSection('content'); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="page-header">
            <h3 class="page-title">
              Dashboard
            </h3>
          </div>
          <div class="row grid-margin">
            <div class="col-12">
              <div class="card card-statistics">
                <div class="card-body">
                  <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fa fa-user mr-2"></i>
                            Total Top-Up Amount
                        </p>
                        <h4><?php echo e(number_format($pettyCash, 2)); ?></h4>
                    </div>
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                            Total Expenses
                        </p>
                        <h4><?php echo e(number_format($Expenses, 2)); ?></h4>
                    </div>
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                            Balance
                        </p>
                        <h4><?php echo e(number_format($pettyCash - $Expenses, 2)); ?></h4>
                        <?php
                            $percentageChange = $Expenses > 0 ? (($pettyCash - $Expenses) / $Expenses) * 100 : 0;
                        ?>
                        <?php if($percentageChange > 0): ?>
                            <label class="badge badge-outline-success badge-pill">Balance Amount</label>
                        <?php else: ?>
                            <label class="badge badge-outline-danger badge-pill">Outstanding Amount</label>
                        <?php endif; ?>
                    </div>
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fas fa-check-circle mr-2"></i>
                            For This Month
                        </p>
                        <h2>7500</h2>
                    </div>
                </div>
                
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-12 grid-margin stretch-card" >
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">
                    <i class="fas fa-gift"></i>
                    Orders
                  </h4>
                  <canvas id="myChart"></canvas>
                  <div id="orders-chart-legend" class="orders-chart-legend"></div>                  
                </div>
              </div>
            </div>
            
          </div>
          
          
         
          <div class="row">
            <div class="col-md-7 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">
                    <i class="fas fa-thumbtack"></i>
                    Todo
                  </h4>
                  <div class="add-items d-flex">
                    <div class="container">
                      <div class="row">
                        <div class="col-md-7">
                          <input type="text" class="form-control todo-list-input"  id="toDo" placeholder="What do you need to do today?">
                        </div>
                        <div class="col-md-3">
                          <input type="date" class="form-control todo-list-input"  id="date">
                        </div>
                        <div class="col-md-2">
                          <button class="add btn btn-primary font-weight-bold todo-list-add-btn" id="add-task">Add</button>
                        </div>
                      </div>
                    </div>
										
                    
									
									</div>
									<div class="list-wrapper">
										<ul class="d-flex flex-column-reverse todo-list">
                      <?php $__currentLoopData = $ToDoList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ToDo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <li>
												<div class="form-check">
													<label class="form-check-label">
														<input class="checkbox" type="checkbox">
														<?php echo e($ToDo->description); ?>

    
													</label>
                          <span style="font-size: 12px">(<?php echo e($ToDo->date); ?>)</span>
												</div>
												<i class="remove fa fa-times-circle delete" data-id="<?php echo e($ToDo->id); ?>"></i>
											</li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

										</ul>
									</div>
                </div>
              </div>
            </div>
            <div class="col-md-5 grid-margin stretch-card">
                <div class="card">
                  <div class="card-body">
                    <h4 class="card-title">
                      <i class="fas fa-calendar-alt"></i>
                      Calendar
                    </h4>
                    <div id="inline-datepicker-example" class="datepicker"></div>
                  </div>
                </div>
              </div>
          </div>
          <div class="row">
            <div class="col-12">
              <div class="card">
                <div class="card-body">
                  <div class="d-md-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-facebook btn-rounded">
                        <i class="fab fa-facebook-f"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Facebook</h5>
                        <p class="mb-0">813 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-twitter btn-rounded">
                        <i class="fab fa-twitter"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Twitter</h5>
                        <p class="mb-0">9000 followers</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-google btn-rounded">
                        <i class="fab fa-google-plus-g"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Google plus</h5>
                        <p class="mb-0">780 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center">
                      <button class="btn btn-social-icon btn-linkedin btn-rounded">
                        <i class="fab fa-linkedin-in"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Linkedin</h5>
                        <p class="mb-0">1090 connections</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:../../partials/_footer.html -->
        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © 2025  <a href="https://www.urbanui.com/" target="_blank">Urbanui</a>. All rights reserved.</span>
            <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Hand-crafted & made with <i class="far fa-heart text-danger"></i></span>
          </div>
        </footer>
        <!-- partial -->
      </div>
      <script>
$(document).ready(function() {
$.ajax({
  url: '<?php echo e(route('get_monthly_report_list')); ?>',
  method: 'get',
  dataType: 'json',
  success: function(response) {
    // Prepare data arrays
    const labels = response.map(item => item.yearMonth);
    const totalExpenses = response.map(item => parseFloat(item.total_expenses) || 0);
    const totalSaleAmount = response.map(item => parseFloat(item.total_Sale_amount) || 0);
    const purchaseAmount = response.map(item => parseFloat(item.purchase_amount) || 0);
 
    // Calculate balance for each month
    const balance = totalSaleAmount.map((sale, i) => {
      return sale - (purchaseAmount[i] + totalExpenses[i]);
    });

    // Determine maximum Y value
    const maxTotal = Math.max(...totalExpenses, ...totalSaleAmount, ...balance);
    const stepSize = 500;
    const maxYAxis = Math.ceil(maxTotal / stepSize) * stepSize;

    // Create chart
    const ctx = document.getElementById('myChart').getContext('2d');
    new Chart(ctx, {
      type: 'bar',
      data: {
        labels: labels,
        datasets: [
          {
            label: 'Total Expenses',
            data: totalExpenses,
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            borderColor: 'rgba(255, 99, 132, 1)',
            borderWidth: 1
          },
          {
            label: 'Purchase Amount',
            data: purchaseAmount,
            backgroundColor: 'rgba(255, 206, 86, 0.2)',
            borderColor: 'rgba(255, 206, 86, 1)',
            borderWidth: 1
          },
          {
            label: 'Total Sale Amount',
            data: totalSaleAmount,
            backgroundColor: 'rgba(54, 162, 235, 0.2)',
            borderColor: 'rgba(54, 162, 235, 1)',
            borderWidth: 1
          },
    {
  label: 'Balance',
  data: balance,
  backgroundColor: 'rgba(0, 0, 0, 0.2)', // Light transparent black fill
  borderColor: 'rgba(0, 0, 0, 1)',       // Solid black line
  borderWidth: 2,
  type: 'line', // Balance shown as line
  tension: 0.3
}
        ]
      },
      options: {
        scales: {
          x: { stacked: false },
          y: {
            beginAtZero: true,
            ticks: { stepSize: stepSize },
            max: maxYAxis
          }
        },
        plugins: {
          legend: { position: 'top' },
          tooltip: {
            callbacks: {
              label: function(context) {
                let label = context.dataset.label || '';
                if (label) label += ': ';
                if (context.parsed.y !== null) {
                  label += context.parsed.y.toFixed(2);
                }
                return label;
              }
            }
          }
        }
      }
    });
  }
});


  $(document).on("click", "#add-task", function (e) {
        e.preventDefault();

        var toDo =$('#toDo').val();
        var date =$('#date').val();

        var isValid = true;
            var errorMessage = '';

            // Perform individual validation checks for each input field
        if (!date || date.length === 0) {
            errorMessage += 'Date is required.<br>';
            isValid = false;
        }
        if (!toDo || toDo.length === 0) {
            errorMessage += 'To Do is required.<br>';
            isValid = false;
        }
       
        if (!isValid) {
                Swal.fire({
                    icon: 'error',
                    title: 'Validation Error',
                    html: errorMessage,
                    showCloseButton: true,
                    showCancelButton: false,
                    focusConfirm: false,
                    confirmButtonText: 'OK',
                });
                return;
      }else{
        var form_data = new FormData();
            form_data.append('_token', '<?php echo e(csrf_token()); ?>');
            form_data.append('toDo', toDo);
            form_data.append('date', date);

            $.ajax({
                url: '/store-todo', // Replace with your backend URL
                type: 'POST',
                data: form_data,
                contentType: false,
                processData: false,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: 'Your data has been submitted successfully!',
                        confirmButtonText: 'OK',
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.reload();
                      }
                    });
                },
                error: function (response) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'There was an error submitting your data.',
                        confirmButtonText: 'OK',
                    });
                }
            });
      }
              
    });


    $(document).on('click', '.delete', function() {
        var id = $(this).data('id');

            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
            })

            swalWithBootstrapButtons.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Do it!',
                cancelButtonText: 'No, cancel!',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "/delete-todo",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: "POST",
                        data: JSON.stringify({
                            'id': id
                        }),
                        contentType: "application/json",
                        success: function(response) {
                            window.location.reload();
                        },
                    });
                    swalWithBootstrapButtons.fire(
                        'To-Do Deleted!',
                        'Your To-Do has been Deleted.',
                        'success'
                    )
                } else if (
                    /* Read more about handling dismissals below */
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'Cancelled',
                        'Your imaginary file is safe  😇 ',
                        'error'
                    )
                }
            })

        }); 
  


});

</script>


<?php $__env->stopSection(); ?>
      <!-- main-panel ends -->
    
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\USER\Desktop\laravel Chat\Sunsmart pety cash\susmart\resources\views/welcome.blade.php ENDPATH**/ ?>