@extends('layouts.app')
@section('content')
<style>
  button.dt-button, div.dt-button, a.dt-button, input.dt-button {
    border-radius: 5px;
    color: white;
    background-color: rgb(197, 7, 178);
    box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;
}

button.dt-button:hover:not(.disabled), div.dt-button:hover:not(.disabled), a.dt-button:hover:not(.disabled), input.dt-button:hover:not(.disabled) {
    border: 1px solid #666;
    background-color: rgb(29, 29, 29);
}

/* CSS */
.button-85 {
 
    margin: 10px;
  padding: 0.6em 2em;
  border: none;
  outline: none;
  color: rgb(255, 255, 255);
  background: #111;
  cursor: pointer;
  position: relative;
  z-index: 0;
  border-radius: 10px;
  user-select: none;
  -webkit-user-select: none;
  touch-action: manipulation;
}

.button-85:before {
  content: "";
  background: linear-gradient(
    45deg,
    #ff0000,
    #ff7300,
    #fffb00,
    #48ff00,
    #00ffd5,
    #002bff,
    #7a00ff,
    #ff00c8,
    #ff0000
  );
  position: absolute;
  top: -2px;
  left: -2px;
  background-size: 400%;
  z-index: -1;
  filter: blur(5px);
  -webkit-filter: blur(5px);
  width: calc(100% + 4px);
  height: calc(100% + 4px);
  animation: glowing-button-85 20s linear infinite;
  transition: opacity 0.3s ease-in-out;
  border-radius: 10px;
}

@keyframes glowing-button-85 {
  0% {
    background-position: 0 0;
  }
  50% {
    background-position: 400% 0;
  }
  100% {
    background-position: 0 0;
  }
}

.button-85:after {
  z-index: -1;
  content: "";
  position: absolute;
  width: 100%;
  height: 100%;
  background: #222;
 
  left: 0;
  top: 0;
  /* border-radius: 10px; */
}
</style>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="page-header">
            <h3 class="page-title">
              Dashboard
            </h3>
          </div>
          @if($purchaseType == 'Add Product')
          <div class="row grid-margin">
            <div class="col-12">
              <div class="card card-statistics">
                <div class="card-body">
                  <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fa fa-user mr-2"></i>
                            Total Quantity
                        </p>
                        <h4>{{ number_format($totalProdutQuantity, 2) }}</h4>
                    </div>
                   
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                            Total Cost
                        </p>
                        <h4>{{ number_format($totalProdutCost, 2) }}</h4>
                    </div>
                    <div class="statistics-item">
                      <p>
                          <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                          Total Paid
                      </p>
                      {{-- <h4>{{ number_format($purchaseTotalSums->overall_total_paid, 2) }}</h4> --}}
                  </div>
                    <div class="statistics-item">
                        <button class="button-85 return"  role="button">Return</button>
                        <button class="button-85" id="edit" role="button">Edit</button>
                        {{-- <h4>{{ number_format($purchaseTotalSums->overall_total_cost - $purchaseTotalSums->overall_total_paid, 2) }}</h4>
                      
                        @if (($purchaseTotalSums->overall_total_cost - $purchaseTotalSums->overall_total_paid) > 0)
                            <label class="badge badge-outline-danger badge-pill">Outstanding Amount</label>
                        @else
                            <label class="badge badge-outline-success badge-pill">Balance Amount</label>
                        @endif --}}
                    </div>
                   
                    
                      
                  </div>
                </div>
              </div>
            </div>
          </div>
         @endif
         @if($purchaseType == 'Add Product By Items')
         <div class="row grid-margin">
           <div class="col-12">
             <div class="card card-statistics">
               <div class="card-body">
                <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
                  <div class="statistics-item">
                      <p>
                          <i class="icon-sm fa fa-user mr-2"></i>
                          Product Name
                      </p>
                      @foreach ($purchaseProducts as $product)
                      {{-- <h4>{{ $product->product_name }}</h4> --}}
                  @endforeach
                  </div>
                 
                  <div class="statistics-item">
                      <p>
                          <i class="icon-sm fas fa-user mr-2"></i>
                          Supplier
                      </p>
                    
                      <h4>{{ $suppliers->name }}</h4>
                
                  </div>
                  <div class="statistics-item">
                    <p>
                      <i class="icon-sm fa fa-user mr-2"></i>
                      Total Quantity
                  </p>
                  <h4>{{ number_format($totalProdutQuantity, 2) }}</h4>
                </div>
                <div class="statistics-item">
                  <button class="button-85 return"  role="button">Return</button>
              </div>
               
                </div>
                <br>
                <hr style="border: 1px solid #dcffce;">
                 <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
                   <div class="statistics-item">
                       <p>
                           <i class="icon-sm fa fa-user mr-2"></i>
                           Total Paid
                       </p>
                       <h4>{{ number_format($product->total_paid, 2) }}</h4>
                   </div>
                  
                   <div class="statistics-item">
                       <p>
                           <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                           Total Cost
                       </p>
                       <h4>{{ number_format($totalProdutCost, 2) }}</h4>
                   </div>
                   <div class="statistics-item">
                     <p>
                         <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                         Balance
                     </p>
                     <h4>{{ number_format($product->total_paid - $totalProdutCost, 2) }}</h4>

                 </div>
                   <div class="statistics-item">
                      
                       <button class="button-85" id="edit" role="button">Edit</button>
                      
                   </div>
                  
                   
                     
                 </div>
               </div>
             </div>
           </div>
         </div>
        @endif
          <div class="content-wrapper">
            {{-- <div class="page-header">
              <h3 class="page-title">
                Data table
              </h3>
              <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="#">Tables</a></li>
                  <li class="breadcrumb-item active" aria-current="page">Data table</li>
                </ol>
              </nav>
            </div> --}}
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">Data table</h4>
                <div class="row">
                  <div class="col-12">

                    @if($purchaseType == 'Add Product')
                    <div class="table-responsive" style="overflow-x: auto; -webkit-overflow-x: auto;">
                        <table id="example" class="table table-striped table-hover table-product  nowrap" style="width: 100%; ">
                        <thead>
                          <tr>
                              <th>Id #</th>
                              <th>Product Name</th>
                              <th>Brand</th>
                              <th>Quantity</th>
                              <th>Cost</th>
                              <th>total Cost</th>
                       
                              {{-- <th>Delete</th> --}}
                          </tr>
                        </thead>
                        <tbody>
                            @foreach ($purchaseProducts as $purchaseProduct)
                            <tr>
                              <td>{{ $purchaseProduct->id }}</td>
                              <td>{{ $purchaseProduct->product_name }}</td>
                              <td>{{ $purchaseProduct->product_brand_name }}</td>
                              <td>{{ $purchaseProduct->quantity }}</td>
                              <td>{{ $purchaseProduct->each_cost }}</td>
                              <td>{{ $purchaseProduct->total_cost }}</td>
                            </tr>
                            @endforeach
                      
                        </tbody>
                      </table>
                    </div>
                    @endif
                    @if($purchaseType == 'Add Product By Items')
                    <div class="table-responsive" style="overflow-x: auto; -webkit-overflow-x: auto;">
                      <table id="example2" class="table table-striped table-hover table-product nowrap" style="width: 100%;">
                        <thead>
                            <tr>
                                <th>Id #</th>
                                <th>Product Name</th>
                                <th>IMU Number</th>
                                <th>Quantity</th>
                                <th>Cost</th>
                            </tr>
                        </thead>
                        <tbody>

                                @foreach ($purchaseProductItem as $ProductItem)
                                    <tr>
                                        <td>{{ $ProductItem->id }}</td>
                                        <td>{{ $ProductItem->product_name }}</td>
                                        <td>{{ $ProductItem->imu_number }}</td>
                                        <td>{{ $ProductItem->quantity }}</td>
                                        <td>{{ number_format($ProductItem->each_cost, 2) }}</td>
                                    </tr>
                                @endforeach

                        </tbody>
                    </table>
                    
                  </div>
                    @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <div class="card">
                <div class="card-body">
                  <div class="d-md-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-facebook btn-rounded">
                        <i class="fab fa-facebook-f"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Facebook</h5>
                        <p class="mb-0">813 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-twitter btn-rounded">
                        <i class="fab fa-twitter"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Twitter</h5>
                        <p class="mb-0">9000 followers</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-google btn-rounded">
                        <i class="fab fa-google-plus-g"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Google plus</h5>
                        <p class="mb-0">780 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center">
                      <button class="btn btn-social-icon btn-linkedin btn-rounded">
                        <i class="fab fa-linkedin-in"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Linkedin</h5>
                        <p class="mb-0">1090 connections</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

      
        <!-- content-wrapper ends -->
        <!-- partial:../../partials/_footer.html -->
        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © 2025  <a href="https://www.urbanui.com/" target="_blank">Urbanui</a>. All rights reserved.</span>
            <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Hand-crafted & made with <i class="far fa-heart text-danger"></i></span>
          </div>
        </footer>
        <!-- partial -->
      </div>
   
     
      <script>
$( document ).ready(function() {


    $(document).on('click', '#edit', function() {
            var currentUrl = window.location.href;

// Create a URL object to parse the query parameters
var url = new URL(currentUrl);

// Get the 'id' query parameter from the URL
var id = url.searchParams.get("id");

            
            var url = '/edit-purchace-product?id=' + id;
            window.location.href = url;
        });


        $(document).on('click', '.return', function() {
            var currentUrl = window.location.href;

// Create a URL object to parse the query parameters
var url = new URL(currentUrl);

// Get the 'id' query parameter from the URL
var id = url.searchParams.get("id");

            
            var url = '/return-purchace-product?id=' + id;
            window.location.href = url;
        });
        


  var branch_id = {{ Session::get('branch_id') }} 

  

  // alert("hi")
  $('#example').DataTable({
            dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            processing: true,
            info: true,
            responsive: true,
            lengthMenu: [
                [10, 25, 50, 100, 200, -1],
                [10, 25, 50, 100, 200, "All"]
            ],
            columns: [
                { data: 'id' },
                { data: 'product_name' },
                { data: 'product_brand_name' },
                { data: 'quantity' },
                { data: 'each_cost' },
                { data: 'total_cost' }
            ]
        });

     
        $('#example2').DataTable({
            dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            processing: true,
            info: true,
            responsive: true,
            lengthMenu: [
                [10, 25, 50, 100, 200, -1],
                [10, 25, 50, 100, 200, "All"]
            ],
            columns: [
                { data: 'id' },
                { data: 'product_name' },
                { data: 'imu_number' },
                { data: 'quantity' },
                { data: 'each_cost' },
            ]
        });

        

      
});
      
      </script>
@endsection
      <!-- main-panel ends -->
    


      <!-- HTML !-->


