@extends('layouts.app')
@section('content')
<style>
  button.dt-button, div.dt-button, a.dt-button, input.dt-button {
    border-radius: 5px;
    color: white;
    background-color: rgb(197, 7, 178);
    box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;
}

button.dt-button:hover:not(.disabled), div.dt-button:hover:not(.disabled), a.dt-button:hover:not(.disabled), input.dt-button:hover:not(.disabled) {
    border: 1px solid #666;
    background-color: rgb(29, 29, 29);
}

.button-34 {
  background: #5E5DF0;
  border-radius: 999px;
  box-shadow: #5E5DF0 0 10px 20px -10px;
  box-sizing: border-box;
  color: #FFFFFF;
  cursor: pointer;
  font-family: Inter,Helvetica,"Apple Color Emoji","Segoe UI Emoji",NotoColorEmoji,"Noto Color Emoji","Segoe UI Symbol","Android Emoji",EmojiSymbols,-apple-system,system-ui,"Segoe UI",Roboto,"Helvetica Neue","Noto Sans",sans-serif;
  font-size: 16px;
  font-weight: 700;
  line-height: 24px;
  opacity: 1;
  outline: 0 solid transparent;
  padding: 8px 18px;
  user-select: none;
  -webkit-user-select: none;
  touch-action: manipulation;
  width: fit-content;
  word-break: break-word;
  border: 0;
}

.btn5{
  background: #670479;
  border-radius: 999px;
  box-shadow: #eb5df0 0 10px 20px -10px;  
}

/* body {
  font-family: Arial, sans-serif;
  background: #f2f2f2;
  padding: 30px;
} */

/* Overlay */
.overlay {
  position: fixed;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(255, 255, 255, 0.2);
  backdrop-filter: blur(5px);
  -webkit-backdrop-filter: blur(5px);
  z-index: 10;
  opacity: 0;
  visibility: hidden;
  transition: all 0.5s ease;
}

.overlay.visible {
  opacity: 1;
  visibility: visible;
}

/* Popup */
.main-popup {
  position: fixed;
  left: 0;
  top: 30px;
  width: 200%;
  height: 650px;
  background-color: #ffffffeb;
  border-radius: 5px;
  opacity: 0;
  visibility: hidden;
  transform: translateY(-20px);
  transition: all .5s ease;
  z-index: 10000;
}

.main-popup.visible {
  opacity: 1;
  visibility: visible;
  transform: translateY(10px);
}

@media (min-width: 500px) {
  .main-popup {
    width: 900px;
    left: 50%;
    margin-left: -450px;
  }
}

.popup-header {
  height: 62px;
  width: 100%;
  display: flex;
  justify-content: center;
  align-items: center;
  position: relative;
}

#popup-close-button a {
  position: absolute;
  right: 10px;
  top: 10px;
  width: 22px;
  height: 22px;
}

#popup-close-button a::before,
#popup-close-button a::after {
  content: '';
  position: absolute;
  right: 10px;
  top: 0;
  width: 3px;
  height: 25px;
  background-color: #090909;
}

#popup-close-button a::before {
  transform: rotate(45deg);
}

#popup-close-button a::after {
  transform: rotate(-45deg);
}

.popup-header ul {
  margin: 0;
  padding: 0;
  list-style: none;
  display: flex;
  width: 100%;
}

.popup-header ul li {
  width: 50%;
  text-align: center;
}

.popup-header ul li a {
  display: block;
  padding: 20px 0;
  text-decoration: none;
  font-size: 1.2em;
  background-color: #f5a158;
  color: #fff;
}

#sign-in.active,
#register.active {
  background-color: transparent;
  color: #2e2e2e;
}

.popup-content {
  height: 100%;
  overflow: hidden;
  position: relative;
}

form.sign-in,
form.register {
  position: absolute;
  width: 100%;
  padding-top: 30px;
  left: 0;
  top: 0;
  transition: all 0.35s ease;
}

form.sign-in.move-left {
  transform: translateX(-450px);
  opacity: 0;
}

form.register {
  opacity: 0;
  transform: translateX(450px);
}

form.register.move-left {
  transform: translateX(0);
  opacity: 1;
}

form label {
  font-size: 1.1em;
  color: #333;
  margin-left: 5%;
}

form input[type="text"],
form input[type="password"] {
  border-radius: 5px;
  width: 90%;
  height: 40px;
  margin: 5px 5% 15px 5%;
  padding: 10px;
  font-size: 1em;
  color: #333;
  border: 1px solid #ccc;
  outline: none;
}

input#submit {
  background-color: #ceaee8;
  color: #fff;
  height: 50px;
  width: 90%;
  margin: 25px 5%;
  border: none;
  border-radius: 5px;
  font-size: 1em;
  cursor: pointer;
}





/* CSS */
.button-87 {
  margin: 5px;
  padding: 10px 10px;
  text-align: center;
  text-transform: uppercase;
  transition: 0.5s;
  background-size: 200% auto;
  color: white;
  border-radius: 10px;
  display: block;
  border: 0px;
  font-weight: 700;
  box-shadow: 0px 0px 14px -7px #f09819;
  background-image: linear-gradient(45deg, #FF512F 0%, #F09819  51%, #FF512F  100%);
  cursor: pointer;
  user-select: none;
  -webkit-user-select: none;
  touch-action: manipulation;
}

.button-87:hover {
  background-position: right center;
  /* change the direction of the change here */
  color: #fff;
  text-decoration: none;
}

.button-87:active {
  transform: scale(0.95);
}

.content form {
        border: 12px solid #f8f8f8;
        background: #f4f4f4;
        padding: 30px 45px 45px;
        margin: 70px 25px 40px;
        border-radius: 5px;
        max-width: 900px;
        box-shadow: 0 1px 7px rgba(0,0,0,0.2);
    }
    .content label {
        display: block;
        font-weight: bold;
        letter-spacing: 0.02em; 
        color: #666;
        text-shadow: 0 0 0 #666;
        padding: 5px 0 8px;
    }
    .content label:not(:first-of-type) {
        margin-top: 30px;
    }
    .content select {   
        width: 100%;
        max-width: 300px;
    }

    /* LC Select - Light theme - by LCweb */


/* container */
/* .lcslt {
    border: 1px solid #aaa;
    background: #fafafa;
    border-radius: 2px;
    transition: all .25s ease;
    font-size: 15px;
} */

.lcslt {
    display: flex
;
    align-items: center;
    flex-direction: row;
    flex-wrap: wrap;
    width: 90%;
   
    min-height: 35px;
    padding: 5px 30px 5px 5px;
    position: relative;
    right: -40px;
    overflow: hidden;
    font-size: 1rem;
}
.lcslt:not(.lcslt-disabled):hover,
.lcslt.lcslt_dd-open,
#lc-select-dd {
    border-color: #8f8f8f;
    background: #fefefe;
}
.lcslt.lcslt_dd-open {
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
}
.lcslt-opt {
    background: #bbb;
    border-radius: 3px;
}
.lcslt:not(.lcslt-multiple):after {
	border-top-color: #888 !important;
}
.lcslt:not(.lcslt-multiple):hover:after,
.lcslt.lcslt_dd-open:not(.lcslt-multiple):after {
	border-top-color: #666 !important;
}
.lcslt:not(.lcslt-multiple) > span {
    padding: 2px 0;
}
.lcslt.lcslt-multiple > span:not(.lcslt-multi-callout) {
    padding: 3px 0 6px;
}
.lcslt:not(.lcslt-multiple) > span:not(.lcslt-placeholder) {
    font-size: 100%;
}
.lcslt > span:not(.lcslt-placeholder):not(.lcslt-multi-callout),
#lc-select-dd li {
    color: #484848;
}


/* disabled status */
.lcslt.lcslt-disabled {
    background: #f4f4f4;
}
.lcslt.lcslt-disabled:not(.lcslt-multiple):after {
	border-top-color: #aaa !important;
}
.lcslt.lcslt-disabled:not(.lcslt-multiple) > span {
    color: #848484;
}
.lcslt.lcslt-disabled .lcslt-multi-selected {
    color: #666;
    padding-left: 9px;
}
.lcslt.lcslt-disabled .lcslt-multi-selected:before {
    display: none;
}


/* multi-option selected items */
.lcslt-multiple {
	font-size: 0.95rem !important;
}
.lcslt-multi-selected,
.lcslt-multi-callout {
    padding: 3px 9px 3px 7px;
    background: #e5e5e5;
    color: #494949;
    border-radius: 50px;
    margin: 0 5px 5px 0;
    transition: all .3s ease;
}
.lcslt-multi-callout {
	padding: 0.75rem 0.4581rem;
	font-family: arial;
	border-radius: 50%;
	font-size: 1rem;
}
.lcslt:not(.lcslt-disabled) .lcslt-multi-selected:hover,
.lcslt:not(.lcslt-disabled) .lcslt-multi-callout:hover {
    background: #ddd;
    color: #3f3f3f; 
}
.lcslt-multi-selected:before {
    padding-right: 6px;
}
.lcslt-placeholder {
	color: #888;
	transform: scale(0.9) translate3d(-5%, -5%, 0);
}


/* dropdown */
#lc-select-dd {
    border-radius: 0 0 4px 4px;
    border-width: 0 1px 1px;
    border-style: solid;
	box-shadow: 0px 3px 3px rgba(0, 0, 0, 0.2);
	font-size: 13px;
    
}
#lc-select-dd li {
    border: none;
    border-top: 1px solid #ddd;
}
.lcslt-search-li {
    border-bottom: 2px dotted #bababa !important;
    box-shadow: 0 1px 0 #fff;
}
.lcslt-search-li input {
	font-size: inherit;
    padding-top: 8px;
    padding-bottom: 8px;
    padding-left: 8px;
    /* font-size: 0.8rem; */
    color: #888;
    background: #fefefe;
}
.lcslt-search-li input:hover,
.lcslt-search-li input:active,
.lcslt-search-li input:focus,
.lcslt-is-searching .lcslt-search-li input {
    color: inherit;
}
.lcslt-search-li:before {
	background: #666;
}
#lc-select-dd li span {
    padding: 7px 12px;
    /* font-size: 0.8rem; */
}
#lc-select-dd li img { 
    padding-right: 7px;
}
.lcslt-group-name {
    font-weight: bold;
}
.lcslt-group-opts > li {
    padding-left: 12px;
}
.lcslt-dd-opt {   
    transition: all .15s ease;
    color: #6f6f6f;
}
#lc-select-dd li.lcslt-dd-opt:not(.lcslt-disabled):not(.lcslt-selected):hover,
#lc-select-dd .lcslt-dd-opt-hlight {  
    color: #333;
    background: #d7eeff;
}
#lc-select-dd li.lcslt-dd-opt.lcslt-disabled {   
    background: #ededed;
    color: #777;
}
#lc-select-dd li.lcslt-selected {   
    color: #fff;
    background: #0078d7;
    text-shadow: 0 0 2px rgba(0,0,0,0.15);
}
#lc-select-dd li.lcslt-selected.lcslt-dd-opt-hlight {
	box-shadow: 6px 0 0 #89caff inset;
}
.lcslt-is-searching li.lcslt-group,
.lcslt-no-results {
    border: none !important;
}
.lcslt-no-results {
    color: #777;
    text-align: center;
    padding: 12px;
}


/* images */
.lcslt-img {
    display: inline-block;
    height: 50px;
    width: 70px;
    margin-right: 20px;
} */
.content-wrapper {
    display: flex;
    justify-content: center; /* Centers horizontally */
    align-items: center;    /* Centers vertically */
           /* Full viewport height */
              /* Full width */
}


</style>
<div class="overlay">
</div>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="page-header">
            <h3 class="page-title">
              {{-- Sale Reference : {{$sale->sale_reference }} --}}
            </h3>
          </div>
          <div class="row grid-margin">
            <div class="col-12">
              <div class="card card-statistics">
                <div class="card-body">
                  <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fa fa-user mr-2"></i>
                            Product Name
                        </p>
                        <h5>{{$products->name }}</h5>
                    </div>
                   
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                            Total Quantity
                        </p>
                        <h5>{{ number_format($purchaseSummary->total_quantity, 2) }}</h5>
                    </div>
                    <div class="statistics-item">
                      <p>
                          <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                          Total Cost
                      </p>
                      <h5>{{ number_format($purchaseSummary->total_cost, 2) }}</h5>
                  </div>
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                            Sale Quantity
                        </p>
                                  <h5>{{ number_format($purchaseSummary->total_sale_quantity, 2) }}</h5>
                        {{-- <h5>{{ $sale->quantity }}</h5> --}}
                        {{-- <h4>{{ number_format($purchaseTotalSums->overall_total_cost - $purchaseTotalSums->overall_total_paid, 2) }}</h4>
                   
                        @if (($purchaseTotalSums->overall_total_cost - $purchaseTotalSums->overall_total_paid) > 0)
                            <label class="badge badge-outline-danger badge-pill">Outstanding Amount</label>
                        @else
                            <label class="badge badge-outline-success badge-pill">Balance Amount</label>
                        @endif --}}
                    </div>
                   
                    
                      
                  </div>
                 
                  <hr>
                  
                </div>
              </div>
            </div>
          </div>
                <div class="col-md-12 grid-margin stretch-card">
                    
              <div class="card">
                <div class="card-body">
                  {{-- <h4 class="card-title">Pills</h4>
                  <p class="card-description">Basic nav pills</p> --}}
                  <ul class="nav nav-pills nav-pills-success" id="pills-tab" role="tablist">
                    <li class="nav-item">
                      <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#pills-home" role="tab" aria-controls="pills-home" aria-selected="true">PRODUCTS</a>
                    </li>
                    <li class="nav-item">
                      <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#pills-profile" role="tab" aria-controls="pills-profile" aria-selected="false">UPDATE</a>
                    </li>
                    {{-- <div style="position: relative; width: 100%; position:relative; top:-50px">
                      <button class="button-34 return" data-id="{{ $sale->id }}" role="button" style="position: absolute; top: 0; right: 120px;">
                          Return Items
                      </button>
                      <button class="button-34 btn5 edit" data-id="{{ $sale->id }}" role="button" style="position: absolute; top: 0; right: 0;">
                          Edit Items
                      </button>
                  </div> --}}
                  
                  
                    
                  </ul>
                 
                  <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                      <div class="media">
                        <div class="table-responsive" style="overflow-x: auto; -webkit-overflow-x: auto;">
                            {{-- @if($saleProduct->isNotEmpty()) --}}
                          <table id="example" class="table table-striped table-hover table-product nowrap" style="width: 100%;">
                            <thead>
                              <tr>
                                <th>Id #</th>
                                <th>Cost</th>
                                <th>Quantity</th>
                                <th>Sale Quantity</th>
                                <th>Branch Name</th>
                                <th>Price</th>
                                <th>View</th>
                {{-- <th>Delete</th> --}}
                              </tr>
                            </thead>
                            <tbody>
                              @foreach($purchaseProductsBadgstocks as $purchaseProductsBadgstock)
                                <tr>
                                  <td>{{ $purchaseProductsBadgstock->id }}</td>
                                  <td>{{ number_format($purchaseProductsBadgstock->each_cost, 2) }}</td>
                                  <td>{{ $purchaseProductsBadgstock->quantity }}</td>
                                  <td>{{ number_format($purchaseProductsBadgstock->sale_quantity, 2) }}</td>
                                  <td>{{ $purchaseProductsBadgstock->branch_name }}</td>
                                  <td>{{ number_format($purchaseProductsBadgstock->price, 2) }}</td>
                                  <td><div class="container">
                                      <button class="button-87" role="button" id="view" data-name="{{ $purchaseProductsBadgstock->name }}" data-model="{{ $purchaseProductsBadgstock->model }}" data-code="{{ $purchaseProductsBadgstock->code }}"
                                       data-id="{{ $purchaseProductsBadgstock->id }}"  data-price="{{ $purchaseProductsBadgstock->price }}"  data-each_cost="{{ $purchaseProductsBadgstock->each_cost }}"  data-image="{{ $purchaseProductsBadgstock->image }}">view</button>
                                  </div>
                                  </td>
                                </tr>
                              @endforeach
                          </tbody>
                        </table>
 
                        </div>
                      </div>
                    </div>
                    <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                      <div class="content-wrapper ">
            <div class="inner-wrapper">
             <div class="col-10 grid-margin stretch-card">
                <div class="card">
                  <div class="card-body">
                    <h4 class="card-title">Add Products & Services</h4>
                    {{-- <p class="card-description">
                      Basic form elements
                    </p> --}}
                    <form class="forms-sample">

                    <div class="form-group">
                         <label for="exampleInputName1 " style="font-size: 0.85rem;">Select Type<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                           <select class="select form-control" id="Type" name="type" style="width: 90%; position: relative; right:-40px;">
                            <option value="Products" {{ $products->products_type == 'Products' ? 'selected' : '' }}>Products</option>
                            <option value="Product Items" {{ $products->products_type == 'Product Items' ? 'selected' : '' }}>Product Items</option>
                            <option value="Services" {{ $products->products_type == 'Services' ? 'selected' : '' }}>Services</option>
                          </select>
                        </div>
                      <div class="form-group">
                        <label for="exampleInputName1 " style="font-size: 0.85rem;">Product Name<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                        <input type="text" class="form-control" id="ProductName" value="{{ $products->name }}" placeholder="Add Product Name Here">
                      </div>
                      
                      <div class="form-group">
                        <label for="exampleInputEmail3 " style="font-size: 0.85rem;">Product Code<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="Code" placeholder="Product Cod Here" value="{{ $products->code }}">
                            <div class="input-group-append">
                                <span class="input-group-text" id="generateRandom">
                                    <i class="fa fa-random" style="cursor: pointer;"></i>
                                </span>
                            </div>
                        </div>
                        
                      </div>
                        {{-- <div class="form-group" id="portionSizesSection" >
                         <label for="exampleInputName1 " style="font-size: 0.85rem;">Select portion sizes<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                            <select class="select form-control" id="portionSizes">
								              <option value="Small">Small</option>
								              <option value="Full">Full</option>
								              <option value="Large">Large</option>
                              <option value="Extra Large">Extra Large</option>
							              </select>
                        </div> --}}
                      <div class="form-group">
                        <label for="exampleSelectGender" style="font-size: 0.85rem;">Select Product Catecory<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                        <select name="simple" data-placeholder="Select something please .." id="Category">
                            @foreach ($productCategories as $productCategory)                                
                                <option value="{{ $productCategory->id }}"
                                  {{ $productCategory->id == $products->product_category_id ? 'selected' : '' }}>
                                {{ $productCategory->category_name }}
                            </option>
                        @endforeach
                      </select>
                        </div>

                        
                      <div class="form-group">
                        <label style="font-size: 0.85rem;">Select Product Sub Catecory</label>
                        <select id="subCategory" name="simple" data-placeholder="Select something please ..">
                    
                        </select>
                      </div>
                      <div class="form-group" id="brandArea">
                        <label for="exampleSelectGender" style="font-size: 0.85rem;" >Select Product Brand</label>
                        <select name="simple" data-placeholder="Select something please .."  id="brand">
                            
                      </select>
                        </div>
                        <div class="form-group" id="productModelSection">
                        <label for="exampleInputPassword4 " style="font-size: 0.85rem;">Product Model</label>
                        <input type="text" class="form-control" id="productModel" value="{{ $products->model }}" placeholder="Product Model Here">
                      </div>
                      <div class="form-group">
                        <label for="exampleInputCity1 " style="font-size: 0.85rem;">Product Price<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                        <input type="text" class="form-control" id="Price" value="{{ $products->price }}" placeholder="Product Price">
                      </div>
                  
                    
                      <div class="form-group">
                        <label for="exampleTextarea1" style="font-size: 0.85rem;">Description</label>
                        <textarea class="form-control" id="description" rows="4"></textarea>
                      </div>  
                      <div class="container form-group">
                        <div class="row">
                            <div class="col-sm">
                                <label for="exampleInputCity1 " style="font-size: 0.85rem;">Wholesale Price<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                                <input type="text" class="form-control" id="WholesalePrice" placeholder="Wholesale Price" value="{{ $products->Wholesale_price }}">
                            </div>
                            <div class="col-sm">
                                <label for="exampleInputCity1 " style="font-size: 0.85rem;">Wholesale Quantity<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                                <input type="text" class="form-control" id="WholesaleQuantity" placeholder="Wholesale Quantity" value="{{ $products->Wholesale_quantity }}">
                            </div>
  
                        </div>
                    </div>

                      <div class="form-group">
                        <label for="exampleInputName1 " style="font-size: 0.85rem;">Alert Quantity</label>
                        <input type="text" class="form-control" id="AlertQuantity" placeholder="Add Alert Quantity Here">
                      </div>
                      <div class="form-group">
                        <label for="exampleTextarea1" style="font-size: 0.85rem;">Upload Images</label>
                        <div class=" grid-margin stretch-card">
                            <div class="card">
                              <div class="">
                                
                                <input type="file"  class="dropify" id="image" data-default-file="{{ asset( $products->image) }}" />
                              </div>
                            </div>
                          </div>
                      </div>

                    
                      <button type="submit" class="btn btn-primary mr-2" id="Update">Update</button>
                      <button type="submit" class="btn btn-light delete">Delete</button>
                    </form>
                  </div>
                </div>
              </div>
          
            </div>
         </div>
                        {{-- <table id="example2" class="table table-striped table-hover table-product nowrap" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th>Id #</th>
                                    <th>Product Name</th>
                                    <th>Total <br> Quantity</th>
                                    <th>Total Cost</th>
                                    <th>Total Paid</th>
                                    <th>Profit</th>
                                    <th>Warranty <br> Period</th>
                                    <th>Days Left</th> 
                                 
                                </tr>
                            </thead>
                            <tbody>
                              
                            </tbody>
                        </table> --}}
                        
                    </div>
                    
                  </div>
                </div>
              </div>
            </div>
       
         
          <div class="content-wrapper">
            
          </div>
          <div class="row">
            <div class="col-12">
              <div class="card">
                <div class="card-body">
                  <div class="d-md-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-facebook btn-rounded">
                        <i class="fab fa-facebook-f"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Facebook</h5>
                        <p class="mb-0">813 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-twitter btn-rounded">
                        <i class="fab fa-twitter"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Twitter</h5>
                        <p class="mb-0">9000 followers</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-google btn-rounded">
                        <i class="fab fa-google-plus-g"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Google plus</h5>
                        <p class="mb-0">780 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center">
                      <button class="btn btn-social-icon btn-linkedin btn-rounded">
                        <i class="fab fa-linkedin-in"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Linkedin</h5>
                        <p class="mb-0">1090 connections</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

      
        <!-- content-wrapper ends -->
        <!-- partial:../../partials/_footer.html -->
        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © 2025  <a href="https://www.urbanui.com/" target="_blank">Urbanui</a>. All rights reserved.</span>
            <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Hand-crafted & made with <i class="far fa-heart text-danger"></i></span>
          </div>
        </footer>
        <!-- partial -->
      </div>
 <div class="main-popup">
  <div class="popup-header">
    <div id="popup-close-button"><a href="#"></a></div>
    <ul>
      <li><a href="#" id="sign-in">Product Details</a></li>
      <li><a href="#" id="register">Product Items</a></li>
    
    </ul>
  </div>

  <div class="popup-content">
    <form  class="sign-in">
      <div class="container">
  <div class="row">
    
    <div class="col-sm">
         <label for="password">NAME:</label>
      <input type="text" id="product-name" readonly>
        <label for="password">MODEL:</label>
      <input type="text" id="product-model" readonly>
         <label for="password">BAR CODE:</label>
      <input type="text" id="product-code">
        <label for="password">Coat:</label>
      <input type="text" id="product-Coat">
        <label for="password">Price:</label>
      <input type="text" id="product-Price">
       <p  class="btn btn-primary mr-2" id="UpdateItem">Update</p>
      
    </div>
  <div class="col-sm">
    <label for="product-code"></label>
      
<svg id="product-barcode"></svg>
<br>
       <img id="product-image-preview" src="" alt="Product Image" style="max-width:100%; height:auto;">
    </div>
  </div>
</div>

    </form>

    <form action="#" class="register">
               <div class="table-responsive" style="overflow-x: auto; -webkit-overflow-x: auto; padding: 30px;">
                            {{-- @if($saleProduct->isNotEmpty()) --}}
    <table id="example3" class="table table-striped table-hover table-product nowrap" style="width: 100%;">
        <thead>
            <tr>
                <th>Id #</th>
                <th>Purchase Id</th>
                <th>Imu</th>
                <th>Quantity</th>
                <th>Cost</th>
                <th>Status</th>
                 <th>View</th>
                {{-- <th>Delete</th> --}}
            </tr>
        </thead>
        <tbody>
          
        </tbody>
    </table>
{{-- @endif --}}

                            
                        </div>
    </form>
  </div>
</div>
     
      <script>
$(function() {
  var $overlay = $('.overlay');
  var $mainPopUp = $('.main-popup');
  var $signIn = $('#sign-in');
  var $register = $('#register');
  var $formSignIn = $('form.sign-in');
  var $formRegister = $('form.register');

  // Show popup
  
    $(document).on("click","#view",function() {

      var id = $(this).data('id'); 
      $('#UpdateItem').attr('data-id', id);

        var image = $(this).data('image'); // Get the image from data-image
        var name = $(this).data('name'); 
        var model = $(this).data('model'); 
        var code = $(this).data('code'); 
        var each_cost = $(this).data('each_cost'); 
        var price = $(this).data('price'); 
        

   

      
    // Set image in the popup
    $('#product-image-preview').attr('src', image);
    $('#product-name').val(name);
    $('#product-model').val(model);
    $('#product-code').val(code);  
    $('#product-Coat').val(each_cost);
    $('#product-Price').val(price);

    JsBarcode("#product-barcode", code, {
  format: "CODE128", // or "EAN13", "UPC", etc., depending on your needs
  lineColor: "#000",
  width: 2,
  height: 50,
  displayValue: true
});
     $.ajax({
    url: '/prduct_list_data',
    headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
    type: 'POST',
    data: {
        'id': id
    },
 success: function(response) {
    const data = response.data;

    var table = $('#example3').DataTable();
    table.clear();

    data.forEach(function(item) {
        const rowClass = item.sale_status === 'sold' ? 'text-danger' : '';

        table.row.add([
            `<span class="${rowClass}">${item.id}</span>`,
            `<span class="${rowClass}">${item.purchases_id}</span>`,
            `<span class="${rowClass}">${item.imu_number}</span>`,
            `<span class="${rowClass}">${item.quantity}</span>`,
            `<span class="${rowClass}">${item.each_cost || ''}</span>`,
            `<span class="${rowClass}">${item.sale_status}</span>`,
            `<button class="btn btn-sm btn-primary">View</button>`
        ]);
    });

    table.draw();
}
,
    error: function(xhr, status, error) {
        console.error('Error:', error);
    }
});



    $overlay.addClass('visible');
    $mainPopUp.addClass('visible');
    $signIn.addClass('active');
    $register.removeClass('active');
    $formRegister.removeClass('move-left');
    $formSignIn.removeClass('move-left');
  });

 $(document).on("click","#UpdateItem",function() {
    var id = $(this).data('id');  
    var productcode = $('#product-code').val();  
    var productCoat = $('#product-Coat').val();
    var productPrice = $('#product-Price').val();

    var form_data = new FormData();
    form_data.append('_token', '{{ csrf_token() }}');
    form_data.append('id', id);
    form_data.append('productcode', productcode);
    form_data.append('productCoat', productCoat);
    form_data.append('productPrice', productPrice);

    $.ajax({
            url: '/update-product-item', // Replace with your backend URL
            type: 'POST',
            data: form_data,
            contentType: false,
            processData: false,
              success: function (response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: 'Your data has been submitted successfully!',
                    confirmButtonText: 'OK',
                }).then((result) => {
                    if (result.isConfirmed) {
                         window.location.reload();
                      }
                    });
                },
                error: function (response) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'There was an error submitting your data.',
                        confirmButtonText: 'OK',
                    });
                }
            });
  
 });

  // Close popup
  $overlay.on('click', function() {
    $(this).removeClass('visible');
    $mainPopUp.removeClass('visible');
  });

  $('#popup-close-button a').on('click', function(e) {
    e.preventDefault();
    $overlay.removeClass('visible');
    $mainPopUp.removeClass('visible');
  });

  // Switch to sign in
  $signIn.on('click', function(e) {
    e.preventDefault();
    $signIn.addClass('active');
    $register.removeClass('active');
    $formSignIn.removeClass('move-left');
    $formRegister.removeClass('move-left');
  });

  // Switch to register
  $register.on('click', function(e) {
    e.preventDefault();
    $signIn.removeClass('active');
    $register.addClass('active');
    $formSignIn.addClass('move-left');
    $formRegister.addClass('move-left');
  });

  // Prevent default submit
  // $('form').on('submit', function(e) {
  //   e.preventDefault(); // Remove this when using real backend
  //   alert("Form submitted (demo only)");
  // });
});

$( document ).ready(function() {

      $(document).on('click', '.edit', function() {
            var id = $(this).data('id');
            var url = '/edit_sale_data?id=' + id;
            window.location.href = url;
      });

        $(document).on('click', '.return', function() {
            var id = $(this).data('id');
            var url = '/return_sale_data?id=' + id;
            window.location.href = url;
        });




  var branch_id = {{ Session::get('branch_id') }} 

  

  // alert("hi")
  $('#example').DataTable({
            dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            processing: true,
            info: true,
            responsive: true,
            lengthMenu: [
                [10, 25, 50, 100, 200, -1],
                [10, 25, 50, 100, 200, "All"]
            ],
       
            createdRow: function(row, data, dataIndex) {
            // Example condition to change font color
            // Adjust condition as needed
                $(row).css('font-size', '15px');
           
        }
        });

          const urlParams = new URLSearchParams(window.location.search);
        const Productid = urlParams.get('id'); // Get the value of 'id'


$('#example3').DataTable({
            dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            buttons: [
                 'csv', 'excel', 'pdf', 'print'
            ],
            processing: true,
            info: true,
            responsive: true,
            lengthMenu: [
                [10, 25, 50, 100, 200, -1],
                [10, 25, 50, 100, 200, "All"]
            ],
       
            createdRow: function(row, data, dataIndex) {
            // Example condition to change font color
            // Adjust condition as needed
                $(row).css('font-size', '15px');
           
        }
        });



           new lc_select(document.querySelector('#Category'), {
        wrap_width: '100%',
        min_for_search: 2,
        pre_placeh_opt: true,
    });
    new lc_select(document.querySelector('#subCategory'), {
        wrap_width: '100%',
        min_for_search: 2,
        pre_placeh_opt: true,
    });
   
        
      // $('#example2').DataTable({
      //       dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
      //           "<'row'<'col-sm-12'tr>>" +
      //           "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
      //       buttons: [
      //           'copy', 'csv', 'excel', 'pdf', 'print'
      //       ],
      //       processing: true,
      //       info: true,
      //       responsive: true,
      //       lengthMenu: [
      //           [10, 25, 50, 100, 200, -1],
      //           [10, 25, 50, 100, 200, "All"]
      //       ],
       
      //       createdRow: function(row, data, dataIndex) {
       
      //           $(row).css('font-size', '15px');
           
      //   }
      //   });

        $(document).on('click', '.delete', function(e) {
             e.preventDefault();
        

            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
            })

            swalWithBootstrapButtons.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Do it!',
                cancelButtonText: 'No, cancel!',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "/delete-prduct",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: "POST",
                        data: JSON.stringify({
                            'Productid': Productid
                        }),
                        contentType: "application/json",
                        success: function(response) {
                            window.location.reload();
                        },
                    });
                    swalWithBootstrapButtons.fire(
                        'Payment Deleted!',
                        'Your Payment has been Deleted.',
                        'success'
                    )
                } else if (
                    /* Read more about handling dismissals below */
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'Cancelled',
                        'Your imaginary file is safe  😇 ',
                        'error'
                    )
                }
            })

        });

        var ExpensesId;
        $(document).on('click', '.request', function() {
          ExpensesId = $(this).data('id');
         
        });
        $(document).on('click', '.RequestDelete', function() {
        var id = ExpensesId;
        var DeleteReason = $('#DeleteReason').val();

            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
            })

            swalWithBootstrapButtons.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Do it!',
                cancelButtonText: 'No, cancel!',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "/Request-delete-expenses",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: "POST",
                        data: JSON.stringify({
                            'id': id,
                            'DeleteReason':DeleteReason
                        }),
                        contentType: "application/json",
                        success: function(response) {
                            window.location.reload();
                        },
                    });
                    swalWithBootstrapButtons.fire(
                        'Payment Deleted!',
                        'Your Payment has been Deleted.',
                        'success'
                    )
                } else if (
                    /* Read more about handling dismissals below */
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'Cancelled',
                        'Your imaginary file is safe  😇 ',
                        'error'
                    )
                }
            })

        });


        

        $(document).on('click', '.view', function() {
            var id = $(this).data('id');
            alert(id)

            var url = '/edit_sale_data?id=' + id;
            window.location.href = url;
        });


         $(document).on('change','#Category', function(){
      
            var id = $('#Category').val();
 
            $.ajax({
                url: "{{ route('get-product-sub-categories') }}",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                data: {'id':id},
            
                success: function(response) {
        // Access the productSubCategory data
        $('#subCategory').empty();  // Clear existing options
        $('#subCategory').append('<option value="">Select Sub Category</option>');
        $.each(response.data.productSubCategory, function(index, subCategory) {
            $('#subCategory').append('<option value="' + subCategory.id + '">' + subCategory.sub_category_name + '</option>');
        });

        // Access the productBrandCategory data
        $('#brand').empty();  // Clear existing options
        $('#brand').append('<option value="">Select Brand Category</option>');
        $.each(response.data.productBrandCategory, function(index, brand) {
            $('#brand').append('<option value="' + brand.id + '">' + brand.product_brand_name + '</option>');
        });
    },
                error: function(xhr, textStatus, errorThrown) {
                    alert('Form submission failed!');
                }
            });
        })


      var CatecoryId = '{{ $products->product_category_id }}';
    var selectedBrandId = parseInt('{{ $products->product_brand_id }}');
    var selectedSubCategoryId = parseInt('{{ $products->product_sub_category_id }}');

    $.ajax({
        url: "{{ route('get-product-sub-categories') }}",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        type: 'POST',
        data: { 'id': CatecoryId },

        success: function(response) {
            // ---------- Sub Category Dropdown ----------
            $('#subCategory').empty();
            let subCategoryMatched = false;

            $.each(response.data.productSubCategory, function(index, subCategory) {
                let selected = '';
                if (subCategory.id === selectedSubCategoryId) {
                    selected = 'selected';
                    subCategoryMatched = true;
                }
                $('#subCategory').append('<option value="' + subCategory.id + '" ' + selected + '>' + subCategory.sub_category_name + '</option>');
            });

            if (!subCategoryMatched) {
                $('#subCategory').prepend('<option value="" selected>Select Sub Category</option>');
            }

            // ---------- Brand Dropdown ----------
            $('#brand').empty();
            let brandMatched = false;

            $.each(response.data.productBrandCategory, function(index, brand) {
                let selected = '';
                if (brand.id === selectedBrandId) {
                    selected = 'selected';
                    brandMatched = true;
                }
                $('#brand').append('<option value="' + brand.id + '" ' + selected + '>' + brand.product_brand_name + '</option>');
            });

            if (!brandMatched) {
                $('#brand').prepend('<option value="" selected>Select Brand Category</option>');
            }

            // ✅ Reinitialize lc_select after populating the #brand select
            new lc_select(document.querySelector('#brand'), {
                wrap_width: '100%',
                min_for_search: 2,
                pre_placeh_opt: true,
            });
        },

        error: function(xhr, textStatus, errorThrown) {
            alert('Form submission failed!');
        }
    });



 $(document).on("click", "#generateRandom", function () {
        // Generate a random 8-character number
        const randomCode = Math.floor(10000000 + Math.random() * 90000000);
        // Set the random number in the input field
        $("#Code").val(randomCode);
    });


      $(document).on("click", "#Update", function (e) {
        e.preventDefault();
        var ProductName =$('#ProductName').val();
        var description =$('#description').val();
        var brand =$('#brand').val();
        var Code =$('#Code').val();
        var AlertQuantity =$('#AlertQuantity').val();
        var productModel =$('#productModel').val();
        var portionSizes =$('#portionSizes').val();
        var producttypes =$('#Type').val();
        var WholesalePrice =$('#WholesalePrice').val();
        var WholesaleQuantity =$('#WholesaleQuantity').val();
        var subCategory =$('#subCategory').val();
        var Category =$('#Category').val();
        var Price =$('#Price').val();
        var image = $('#image')[0].files[0];

        var isValid = true;
            var errorMessage = '';

            // Perform individual validation checks for each input field
        if (!ProductName || ProductName.length === 0) {
            errorMessage += 'Product Name is required.<br>';
            isValid = false;
        }
        if (!Category || Category.length === 0) {
            errorMessage += 'Category is required.<br>';
            isValid = false;
        }
        if (!Code || Code.length === 0) {
            errorMessage += 'Code is required.<br>';
            isValid = false;
        }
        if (!Price || Price.length === 0) {
            errorMessage += 'Price is required.<br>';
            isValid = false;
        }
      
        if (!isValid) {
                Swal.fire({
                    icon: 'error',
                    title: 'Validation Error',
                    html: errorMessage,
                    showCloseButton: true,
                    showCancelButton: false,
                    focusConfirm: false,
                    confirmButtonText: 'OK',
                });
                return;
      }else{
        var form_data = new FormData();
            form_data.append('_token', '{{ csrf_token() }}');
            form_data.append('ProductName', ProductName);
            form_data.append('Productid', Productid);
            form_data.append('model', productModel);
             form_data.append('portionSizes', portionSizes); 
            form_data.append('brand', brand);
            form_data.append('Code', Code);
            form_data.append('WholesaleQuantity', WholesaleQuantity);
            form_data.append('WholesalePrice', WholesalePrice); 
            form_data.append('Price', Price);
            form_data.append('Category', Category);
            form_data.append('AlertQuantity', AlertQuantity);
            form_data.append('subCategory', subCategory);
            form_data.append('productstype', producttypes);
            
            form_data.append('description', description);
            if (image) {
                form_data.append('image', image); // Add image to FormData
            }

            $.ajax({
                url: '/update-product', // Replace with your backend URL
                type: 'POST',
                data: form_data,
                contentType: false,
                processData: false,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: 'Your data has been submitted successfully!',
                        confirmButtonText: 'OK',
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.reload();
                      }
                    });
                },
                error: function (response) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'There was an error submitting your data.',
                        confirmButtonText: 'OK',
                    });
                }
            });
      }
              
    });

});
      
      </script>
@endsection
      <!-- main-panel ends -->
    <!-- HTML !-->



