@extends('layouts.app')
@section('content')
<style>
  button.dt-button, div.dt-button, a.dt-button, input.dt-button {
    border-radius: 5px;
    color: white;
    background-color: rgb(197, 7, 178);
    box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;
}

button.dt-button:hover:not(.disabled), div.dt-button:hover:not(.disabled), a.dt-button:hover:not(.disabled), input.dt-button:hover:not(.disabled) {
    border: 1px solid #666;
    background-color: rgb(29, 29, 29);
}

.content form {
        border: 12px solid #f8f8f8;
        background: #f4f4f4;
        padding: 30px 45px 45px;
        margin: 70px 25px 40px;
        border-radius: 5px;
        max-width: 900px;
        box-shadow: 0 1px 7px rgba(0,0,0,0.2);
    }
    .content label {
        display: block;
        font-weight: bold;
        letter-spacing: 0.02em; 
        color: #666;
        text-shadow: 0 0 0 #666;
        padding: 5px 0 8px;
    }
    .content label:not(:first-of-type) {
        margin-top: 30px;
    }
    .content select {   
        width: 100%;
        max-width: 300px;
    }

    /* LC Select - Light theme - by LCweb */


/* container */
.lcslt {
    border: 1px solid #aaa;
    background: #fafafa;
    border-radius: 2px;
    transition: all .25s ease;
    font-size: 15px;
}
.lcslt:not(.lcslt-disabled):hover,
.lcslt.lcslt_dd-open,
#lc-select-dd {
    border-color: #8f8f8f;
    background: #fefefe;
}
.lcslt.lcslt_dd-open {
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
}
.lcslt-opt {
    background: #bbb;
    border-radius: 3px;
}
.lcslt:not(.lcslt-multiple):after {
	border-top-color: #888 !important;
}
.lcslt:not(.lcslt-multiple):hover:after,
.lcslt.lcslt_dd-open:not(.lcslt-multiple):after {
	border-top-color: #666 !important;
}
.lcslt:not(.lcslt-multiple) > span {
    padding: 2px 0;
}
.lcslt.lcslt-multiple > span:not(.lcslt-multi-callout) {
    padding: 3px 0 6px;
}
.lcslt:not(.lcslt-multiple) > span:not(.lcslt-placeholder) {
    font-size: 130%;
}
.lcslt > span:not(.lcslt-placeholder):not(.lcslt-multi-callout),
#lc-select-dd li {
    color: #484848;
}


/* disabled status */
.lcslt.lcslt-disabled {
    background: #f4f4f4;
}
.lcslt.lcslt-disabled:not(.lcslt-multiple):after {
	border-top-color: #aaa !important;
}
.lcslt.lcslt-disabled:not(.lcslt-multiple) > span {
    color: #848484;
}
.lcslt.lcslt-disabled .lcslt-multi-selected {
    color: #666;
    padding-left: 9px;
}
.lcslt.lcslt-disabled .lcslt-multi-selected:before {
    display: none;
}


/* multi-option selected items */
.lcslt-multiple {
	font-size: 0.95rem !important;
}
.lcslt-multi-selected,
.lcslt-multi-callout {
    padding: 3px 9px 3px 7px;
    background: #e5e5e5;
    color: #494949;
    border-radius: 50px;
    margin: 0 5px 5px 0;
    transition: all .3s ease;
}
.lcslt-multi-callout {
	padding: 0.75rem 0.4581rem;
	font-family: arial;
	border-radius: 50%;
	font-size: 1rem;
}
.lcslt:not(.lcslt-disabled) .lcslt-multi-selected:hover,
.lcslt:not(.lcslt-disabled) .lcslt-multi-callout:hover {
    background: #ddd;
    color: #3f3f3f; 
}
.lcslt-multi-selected:before {
    padding-right: 6px;
}
.lcslt-placeholder {
	color: #888;
	transform: scale(0.9) translate3d(-5%, -5%, 0);
}


/* dropdown */
#lc-select-dd {
    border-radius: 0 0 4px 4px;
    border-width: 0 1px 1px;
    border-style: solid;
	box-shadow: 0px 3px 3px rgba(0, 0, 0, 0.2);
	font-size: 13px;
    
}
#lc-select-dd li {
    border: none;
    border-top: 1px solid #ddd;
}
.lcslt-search-li {
    border-bottom: 2px dotted #bababa !important;
    box-shadow: 0 1px 0 #fff;
}
.lcslt-search-li input {
	font-size: inherit;
    padding-top: 8px;
    padding-bottom: 8px;
    padding-left: 8px;
    /* font-size: 0.8rem; */
    color: #888;
    background: #fefefe;
}
.lcslt-search-li input:hover,
.lcslt-search-li input:active,
.lcslt-search-li input:focus,
.lcslt-is-searching .lcslt-search-li input {
    color: inherit;
}
.lcslt-search-li:before {
	background: #666;
}
#lc-select-dd li span {
    padding: 7px 12px;
    /* font-size: 0.8rem; */
}
#lc-select-dd li img { 
    padding-right: 7px;
}
.lcslt-group-name {
    font-weight: bold;
}
.lcslt-group-opts > li {
    padding-left: 12px;
}
.lcslt-dd-opt {   
    transition: all .15s ease;
    color: #6f6f6f;
}
#lc-select-dd li.lcslt-dd-opt:not(.lcslt-disabled):not(.lcslt-selected):hover,
#lc-select-dd .lcslt-dd-opt-hlight {  
    color: #333;
    background: #d7eeff;
}
#lc-select-dd li.lcslt-dd-opt.lcslt-disabled {   
    background: #ededed;
    color: #777;
}
#lc-select-dd li.lcslt-selected {   
    color: #fff;
    background: #0078d7;
    text-shadow: 0 0 2px rgba(0,0,0,0.15);
}
#lc-select-dd li.lcslt-selected.lcslt-dd-opt-hlight {
	box-shadow: 6px 0 0 #89caff inset;
}
.lcslt-is-searching li.lcslt-group,
.lcslt-no-results {
    border: none !important;
}
.lcslt-no-results {
    color: #777;
    text-align: center;
    padding: 12px;
}


/* images */
.lcslt-img {
    display: inline-block;
    height: 50px;
    width: 70px;
    margin-right: 20px;
} */


</style>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="page-header">
            <h3 class="page-title">
              Dashboard
            </h3>
          </div>
          <div class="row grid-margin">
            <div class="col-12">
              <div class="card card-statistics">
                <div class="card-body">
                  <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
                    
                      <div class="statistics-item">
                        <h4>Creat New Sub Catecory</hr>
                      </div>
                      <div class="statistics-item">
                       
                        <h2><button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#exampleModal-2">Click Me 😊 <i class="fa fa-play-circle ml-1"></i></button></h2>
                        <label class="badge badge-outline-success badge-pill"></label>
                      </div>
                    
                      
                  </div>
                </div>
              </div>
            </div>
          </div>
         
          <div class="content-wrapper">
            {{-- <div class="page-header">
              <h3 class="page-title">
                Data table
              </h3>
              <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="#">Tables</a></li>
                  <li class="breadcrumb-item active" aria-current="page">Data table</li>
                </ol>
              </nav>
            </div> --}}
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">Data table</h4>
                <div class="row">
                  <div class="col-12">
                    <div class="table-responsive" style="overflow-x: auto; -webkit-overflow-x: auto;">
                        <table id="example" class="table table-striped table-hover table-product  nowrap" style="width: 100%; ">
                        <thead>
                          <tr>
                              <th>Id #</th>
                              <th>Category</th>
                              <th>Sub Category</th>
                              <th>Description</th>
                              <th>Delete</th>
                          </tr>
                        </thead>
                        <tbody>
                         
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <div class="card">
                <div class="card-body">
                  <div class="d-md-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-facebook btn-rounded">
                        <i class="fab fa-facebook-f"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Facebook</h5>
                        <p class="mb-0">813 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-twitter btn-rounded">
                        <i class="fab fa-twitter"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Twitter</h5>
                        <p class="mb-0">9000 followers</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-google btn-rounded">
                        <i class="fab fa-google-plus-g"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Google plus</h5>
                        <p class="mb-0">780 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center">
                      <button class="btn btn-social-icon btn-linkedin btn-rounded">
                        <i class="fab fa-linkedin-in"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Linkedin</h5>
                        <p class="mb-0">1090 connections</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:../../partials/_footer.html -->
        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © 2025  <a href="https://www.urbanui.com/" target="_blank">Urbanui</a>. All rights reserved.</span>
            <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Hand-crafted & made with <i class="far fa-heart text-danger"></i></span>
          </div>
        </footer>
        <!-- partial -->
      </div>
      <div class="modal fade" id="exampleModal-2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2" aria-hidden="true">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header" style="background-color: rgb(44, 3, 114)">
              <h5 class="modal-title" id="exampleModalLabel-2" style="color: white">Modal title</h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close"  style="color: white">
                <span aria-hidden="true"  style="color: white; ">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <form class="forms-sample">
                <div class="form-group">
                  <label for="exampleInputEmail1">Select Category</label>
                  <select name="simple" data-placeholder="Select something please .." id="Category">
                    @foreach ($ExpensesCategories as $ExpensesCategory)
                    {{-- <option value="{{ $branche->id }}"
                        {{ $branche->branch_name == $customers->branch_name ? 'selected' : '' }}> --}}
                        <option value="{{ $ExpensesCategory->id }}">
                        {{ $ExpensesCategory->expenses_category }}
                    </option>
                @endforeach
                </select>
                </div>
                <div class="form-group">
                  <label for="exampleInputPassword1">Sub Category</label>
                  <input type="text" class="form-control" id="SubCategory" placeholder="SubCategory">
                </div>
                <div class="form-group">
                  <label for="description">Description</label>
                  <textarea id="description" name="description" rows="4" cols="50"></textarea>
                </div>
             
                <div class="form-group">
                  <div class="form-check form-check-flat form-check-primary">
                    <label class="form-check-label">
                      <input type="checkbox" class="form-check-input">
                      Remember me
                    </label>
                  </div>
                </div>
                
              </form>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-primary store">Submit</button>
              <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
            </div>
          </div>
        </div>
      </div>
      <script src="{{ asset('js/lc_select.min.js') }}"></script>
      <script src="{{ asset('js/lc_select.js') }}"></script>
      <script>
        
$( document ).ready(function() {

  $(document).on('click', '.store', function() {    
    var Category =$('#Category').val();
    var SubCategory =$('#SubCategory').val();
    var description =$('#description').val();
    $.ajax({
        url: '{{ route('store.Sub.Category') }}',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        type: 'POST',
        data: {
          Category:Category,
          SubCategory:SubCategory,
          description:description
        },
        success: function(response) {
          Swal.fire(
              'Good job!',
              response.message,
              'success'
          );
        },
            error: function(xhr, status, error) {
// Handle error response from the backend
            console.error('Error:', error);
        }
    });




// var url = '/make-my-itinerary';
// window.location.href = url;
});
//   new lc_select($('#Category')[0], {
//                 wrap_width: '100%',
//                 min_for_search: 3,
//                 pre_placeh_opt: true,
//             });

new lc_select(document.querySelector('#Category'), {
        wrap_width: '100%',
        enable_search: true,
        min_for_search: 3,
        pre_placeh_opt: true,
    });
  // alert("hi")
  $('#example').DataTable({
            dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            processing: true,
            info: true,
            responsive: true,
            lengthMenu: [
                [10, 25, 50, 100, 200, -1],
                [10, 25, 50, 100, 200, "All"]
            ],
            ajax: "{{ route('list_expenses_sub_category') }}",
            columns: [
                {
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'expenses_category',
                    name: 'expenses_category'
                },
                {
                    data: 'expenses_sub_category',
                    name: 'expenses_sub_category'
                },
                {
                    data: 'description',
                    name: 'description'
                },
               
                {
                    data: 'id',
                    name: 'view',
                    render: function(data, type, row, meta) {
                        return `<button type="button" class="btn  btn-outline-success delete"  data-id="${data}" style="height:32px; margin:0px;">Delete</button>`;
                    }
                },
            ],

           
            createdRow: function(row, data, dataIndex) {
            // Example condition to change font color
            // Adjust condition as needed
                $(row).css('font-size', '15px');
           
        }
        });


        $(document).on('click', '.delete', function() {
        var id = $(this).data('id');

            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
            })

            swalWithBootstrapButtons.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Do it!',
                cancelButtonText: 'No, cancel!',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "/delete-expenses-subcategory",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: "POST",
                        data: JSON.stringify({
                            'id': id
                        }),
                        contentType: "application/json",
                        success: function(response) {
                            window.location.reload();
                        },
                    });
                    swalWithBootstrapButtons.fire(
                        'Payment Deleted!',
                        'Your Payment has been Deleted.',
                        'success'
                    )
                } else if (
                    /* Read more about handling dismissals below */
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'Cancelled',
                        'Your imaginary file is safe  😇 ',
                        'error'
                    )
                }
            })

        });

           
        
});
      
      </script>
@endsection
      <!-- main-panel ends -->
    