<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_payments', function (Blueprint $table) {
            $table->id();
              $table->unsignedBigInteger('purchases_id');
            $table->date(column: 'date');
            $table->decimal('amount', 25, 2);
            $table->string('method')->default("cash"); 
            $table->text('payment_note')->nullable();
            $table->text('purchases_note')->nullable(); 
            $table->text('staff_note')->nullable();  
            $table->foreign('purchases_id')->references('id')->on('purchases')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_payments');
    }
};
