<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sale_id');
            $table->unsignedBigInteger('item_id');
            $table->unsignedBigInteger('sale_product_id');
            $table->string('imu_number'); 
            $table->decimal('cost', 25, 2);
            $table->decimal('price', 25, 2);
            $table->string('warranty_status')->nullable(); 
            $table->string('warranty_period')->nullable(); 
            $table->decimal('quantity', 10);
            $table->foreign('sale_id')->references('id')->on('sales');
            $table->foreign('item_id')->references('id')->on('purchase_product_items');
            $table->foreign('sale_product_id')->references('id')->on('sale_products');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_items');
    }
};
