<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('sales_payments', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('sale_id');
    $table->date('date');
    $table->decimal('amount', 25, 2);
    $table->string('method')->default("cash"); 
    $table->string('voucher')->nullable();  
    $table->text('payment_note')->nullable();
    $table->text('sale_note')->nullable(); 
    $table->text('staff_note')->nullable();  
    $table->foreign('sale_id')->references('id')->on('sales')->onDelete('cascade');
    $table->timestamps();
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_payments');
    }
};
