<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_product_items', function (Blueprint $table) {
            $table->id();
            $table->string(column: 'imu_number')->unique();
            $table->unsignedBigInteger('product_id');
            $table->unsignedBigInteger('purchases_id');
            $table->decimal('quantity', 10);
            $table->decimal('each_cost', 10, 2);
            $table->decimal('price', 10, 2);
            $table->unsignedBigInteger('products_badgstock_id');
            $table->unsignedBigInteger('branches_id');
            $table->foreign('products_badgstock_id')->references('id')->on('purchase_products_badgstock')->onDelete('cascade');
            $table->foreign('branches_id')->references('id')->on('branches')->onDelete('cascade');
            $table->foreign('product_id')->references('id')->on('products');
            $table->foreign('purchases_id')->references('id')->on('purchases');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_product_items');
    }
};
