<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string(column: 'name');
            $table->string(column: 'model')->nullable();
            $table->string(column: 'products_type')->nullable();
            $table->string(column: 'portion_sizes')->nullable();

            $table->string(column: 'code')->unique();
            $table->unsignedBigInteger('product_category_id');
            $table->unsignedBigInteger('product_sub_category_id')->nullable();
            $table->unsignedBigInteger('product_brand_id')->nullable();
            $table->decimal(column: 'alert_quantity')->nullable();
            $table->string(column: 'image')->nullable();
            $table->string(column: 'Wholesale_price')->nullable();
            $table->string(column: 'Wholesale_quantity')->nullable();
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2);
            $table->decimal('cost', 10, 2)->nullable();
            $table->decimal(column: 'quantity')->default(0);
            $table->decimal('sale_quantity', 10)->default(0);
            $table->foreign('product_category_id')->references('id')->on('product_categories')->onDelete('cascade');
            $table->foreign('product_brand_id')->references('id')->on('product_brand_categories')->onDelete('cascade');
            $table->foreign('product_sub_category_id')->references('id')->on('product_sub_categories')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
