<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_brand_categories', function (Blueprint $table) {
            $table->id();
            $table->string('product_brand_name');
            $table->string('product_brand_code')->unique();
            $table->unsignedBigInteger('product_category_id');
            $table->string(column: 'image')->nullable();
            $table->text('description')->nullable();
            $table->foreign('product_category_id')->references('id')->on('product_categories')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_brand_categories');
    }
};
