<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->string('date')->nullable();
            $table->string('time')->nullable();
            $table->string('expenses')->nullable();
            $table->string('Payment_method')->nullable();
            $table->decimal('amount', 25,2);
            $table->text('description')->nullable();
            $table->text('delete_reason')->nullable();
            $table->integer('delete_permission')->default(0);
            $table->unsignedBigInteger('branches_id');
            $table->foreign('branches_id')->references('id')->on('branches')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
