<?php

namespace App\Http\Controllers\SaleSetting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\productCategory;
use App\Models\productBrandCategory;
use App\Models\ToDoList;
class productbrandController extends Controller
{
    public function productBrand()
    {   
        $ToDoList = ToDoList::get();
        $productCategories = productCategory::get();
        return view('Section.SaleSettings.productBrand',compact('ToDoList','productCategories'));
      
    }

    public function storeProductBrand(Request $request)
    {
        $data = $request->all();
        $productCategory =  productBrandCategory::create([
            'product_brand_name' => $data['brandName'],
            'product_brand_code' => $data['code'],
            'product_category_id' => $data['Category'],
            'description' => $data['description'],

        ]);

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . rand(1, 9) . '.' . $image->getClientOriginalExtension();
            $image->move('assets/ProductBrand', $imageName);
    
            // Save the image details (if associated with another model or field in `People`)
            $productCategory->image = 'assets/ProductBrand/' . $imageName;
            $productCategory->save();
        }
        
        if($productCategory){
            return response()->json([
                'status' => 'Success',
                'message' => 'Category created successfully'
            ]);
        }
    }

   
    public function listProductBrand(Request $request)
    {
        $productBrandCategory = productBrandCategory::leftJoin('product_categories', 'product_brand_categories.product_category_id', '=', 'product_categories.id')
    ->select('product_brand_categories.*', 'product_categories.category_name')
    ->get();

        $response['data'] = $productBrandCategory;
        return response()->json($response);
    }

    public function deleteProductBrand(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $productBrandCategory = productBrandCategory::find($id);
        if (!$productBrandCategory) {
            return response()->json(['message' => 'Staff member not found'], 404);
        }

        $productBrandCategory->delete();

        return response()->json(['message' => 'Staff member deleted'], 200);

    
    }

    
}
