<?php

namespace App\Http\Controllers\SaleSetting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\productCategory;
use App\Models\productSubCategory;
use App\Models\productBrandCategory;
use App\Models\ToDoList;
class productCategoryController extends Controller
{
    public function productCategory()
    {   
        $ToDoList = ToDoList::get();
        return view('Section.SaleSettings.productCategory',compact('ToDoList'));
      
    }

    public function productSubCategory()
    {   
        $ToDoList = ToDoList::get();
        $productCategories = productCategory::get();
        return view('Section.SaleSettings.productsubCategory',compact('ToDoList','productCategories'));
      
    }

    public function storeProductCategory(Request $request)
    {
        $data = $request->all();
        $productCategory =  productCategory::create([
            'category_name' => $data['Category'],
            'category_code' => $data['CategoryCode'],
            'description' => $data['description'],

        ]);

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . rand(1, 9) . '.' . $image->getClientOriginalExtension();
            $image->move('assets/ProductCategory', $imageName);
    
            // Save the image details (if associated with another model or field in `People`)
            $productCategory->image = 'assets/ProductCategory/' . $imageName;
            $productCategory->save();
        }

        if($productCategory){
            return response()->json([
                'status' => 'Success',
                'message' => 'Category created successfully'
            ]);
        }
    }

    public function storeSubCategory(Request $request)
    {
        $data = $request->all();
        $productCategory =  productSubCategory::create([
            'sub_category_name' => $data['subCategory'],
            'sub_category_code' => $data['code'],
            'product_category_id' => $data['Category'],
            'description' => $data['description'],

        ]);
        if($productCategory){
            return response()->json([
                'status' => 'Success',
                'message' => 'Category created successfully'
            ]);
        }
    }


    

    public function listProductCategory(Request $request)
    {
        $productCategory = productCategory::get();
        $response['data'] = $productCategory;
        return response()->json($response);
    }


    public function listProductSubCategory(Request $request)
    {
        $productSubCategory = productSubCategory::leftJoin('product_categories', 'product_sub_categories.product_category_id', '=', 'product_categories.id')
    ->select('product_sub_categories.*', 'product_categories.category_name')
    ->get();

        $response['data'] = $productSubCategory;
        return response()->json($response);
    }
    
    
    public function deleteProductCategory(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $productCategory = productCategory::find($id);
        if (!$productCategory) {
            return response()->json(['message' => 'Staff member not found'], 404);
        }

        $productCategory->delete();

        return response()->json(['message' => 'Staff member deleted'], 200);

    
    }

    public function deleteSubProductCategory(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $productSubCategory = productSubCategory::find($id);
        if (!$productSubCategory) {
            return response()->json(['message' => 'Staff member not found'], 404);
        }

        $productSubCategory->delete();

        return response()->json(['message' => 'Staff member deleted'], 200);

    
    }

    public function getProductSubCategory(Request $request)
    {
        $data = $request->all();
        $id =$data['id'];
        $productSubCategory = productSubCategory::where('product_sub_categories.product_category_id',$id)->get();
        $productBrandCategory = productBrandCategory::where('product_brand_categories.product_category_id',$id)->get();
        return response()->json([
            'data' => [
                'productSubCategory' => $productSubCategory,
                'productBrandCategory' => $productBrandCategory
            ]
        ]);

    }
    
}
