<?php

namespace App\Http\Controllers\BusinessManage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Branches;

class branchController extends Controller
{
    public function branchBeforeUserRegistration()
    {
        return view('auth.branchRegisterBefore');
    }

    public function store(Request $request)
    {
       
        $request->validate([
            'BranchName' => 'required|string|max:300|unique:branches,branch_name',
            'address' => 'required|string|max:450',
            'ContactNumber' => 'required|string|size:10',
            'FixedContactNumber' => 'string|size:10',
        ]);
        Branches::create([
            'branch_name' => $request->input('BranchName'),
            'address' => $request->input('address'),
            'contact_number' => $request->input('ContactNumber'),
            'contact_number_fixed' => $request->input('FixedContactNumber'),
        ]);

        if (session()->has('user_id')) {
            return redirect()->back();
        } else {
            return redirect()->route('register');
        }
       
        // If the validation passes, you can store the data in the database or perform other actions here.
    }

    
     public function updateBranch(Request $request)
{
    $data = $request->all();
    $id = $data['id'];
   
    

    // Find the existing customer
    $Branches = Branches::find($id);

    if (!$Branches) {
        return response()->json([
            'message' => 'Customer not found.',
        ], 404);
    }

    // Update basic fields
        $Branches->branch_name = $data['updateBranchName'];
        $Branches->address = $data['address'];
        $Branches->contact_number = $data['contactNumber'];
        $Branches->contact_number_fixed = $data['FixedContactNumber'];

  
    $Branches->save();

    return response()->json([
        'message' => 'Customer updated successfully!',
        'data' => $Branches,
    ], 200);
}
}
