<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use App\Models\Branches;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    // use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * 
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * 
     */
    // public function __construct()
    // {
    //     $this->middleware('guest')->except('logout');
    //     $this->middleware('auth')->only('logout');
    // }
  
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'email' => 'required|string|max:255|email',
            'password' => 'required|string|max:255',
        ]);
    }


    public function login(Request $request)
    {
        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials)) {
            $user = Auth::user(); // Get the authenticated user
            $branch = Branches::where('id', $user->branch_id)->first();

            // Store user's name and id in the session
            Session::put('user_name', $user->name);
            Session::put('status', $user->status);
            Session::put('user_id', $user->id);
            Session::put('role', $user->role);

            if ($branch) {
                Session::put('user_branch', $branch->branch_name);
                Session::put('branch_id', $branch->id);
            } else {
                Session::put('user_branch', 'Main Branch');
            }

            // Authentication was successful
            return redirect('/');
        } else {
            // Authentication failed
            return back()->withErrors(['email' => 'Invalid credentials']);
        }
    }



    public function showLoginForm()
    {
        if (session('user_name')) {
            return redirect('/');
        } else {
            return view('auth.login');
        }
        // if (Auth::check()) {
        //     if (session('user_name')) {
        //         return redirect('/');
        //     }
        // } else {
        //     return view('auth.login');
        // }
    // Fetch all branch records
       
    }

    public function logout()
    { 
        // if(Session::has('user_name')){
        //     Session::forget(['user_name', 'user_id', 'user_branch','status','branch_id','role']);
        // }
        // return redirect('login');
        Auth::logout();

        // Clear all session data
        Session::flush();
    
        // Redirect to the login page
        return redirect('login');
    }
}
